# 패리티 비트 & 해밍 코드

정보의 전달 과정에서 오류가 생기는 것을 검사하고 수정하기 위해 패리티 비트와 해밍 코드를 사용한다.

## 패리티 비트 (Parity Bit)
- 패리티 비트는 정보의 전달 과정에서 오류가 생겼는지를 **검사**하기 위해 추가된 비트이다.
- 1Byte(8bit) 데이터에서 7bit 크기의 ASCII 코드를 제외한 나머지 1bit가 패리티(Parity) 비트이다.
- 패리티비트를 포함하여 1의 개수가 짝수나 홀수개가 되도록 하여 오류를 검출한다.

<img src="https://www.nise.go.kr/sedu/pt/images/1_5/1_5_1.jpg" height="160px">

### 짝수 패리티
1의 개수를 **짝수**로 맞춘다.  
> 1101001의 데이터는 1의 개수가 4개(짝수) 이므로, 짝수 패리티 비트는 0이 된다.

### 홀수 패리티
1의 개수를 **홀수**로 맞춘다.
> 1101001의 데이터는 1의 개수가 4개(짝수) 이므로, 홀수 패리티 비트는 1이 된다.

### 특징
- 짝수 홀수 개수로만 검증하므로 2개의 bit, 짝수개의 데이터가 손실되면 검출할 수 없다.  
- 오류 검출만 하며 수정하지는 않는다.

<br/>

## 해밍 코드 (Hamming code)
- 데이터 전송 시 1비트의 오류를 **검출**하고 **수정**할 수 있는 코드이다.  

### 해밍 코드 생성
- 8bit 기준으로 2의 n승 번째 자리인 1, 2, 4번째 자리에 패리티 비트가, 그리고 나머지에 ASCII 코드가 들어간다.  
- 아래의 이미지 처럼, pn(`2^n`번째 패리티비트)은 n의 간격으로 n개의 bit를 확인하여 패리티비트를 결정한다.
    > p2는 2, 3, 6, 7번째 비트를 확인하여 패리티비트를 결정한다.

![스크린샷 2023-01-26 오후 12 06 42](https://user-images.githubusercontent.com/70997596/214756283-821292a4-3c59-4846-9c58-84e8e49b0be1.png)

### 해밍 코드를 통한 오류 검출 및 수정

- 각 패리티비트를 체크하여 오류가 있는지 검출한다.  
- 패리티비트가 올바르면 0, 틀리면 1을 기록하고 이의 역순을 10진법으로 바꾸면 오류가 있는 비트의 위치를 알 수 있다.

> 짝수 패리티의 해밍 코드가 0010011일때 오류 수정 예시  
>  - p1(1, 3, 5, 7번째 비트 확인): 1이 짝수개로 패리티비트 0이 맞다. `0`  
>  - p2(2, 3, 6, 7번째 비트 확인): 1이 홀수개로 패리티비트가 1이어야하는데 0이다. `1`  
>  - p4(4, 5, 6, 7번째 비트 확인): 1이 홀수개로 패리티비스 1이 맞다. `0`
> 
> 역순으로 나온 수 `010`을 10진법으로 바꾸면 `2`이므로 두 번째 비트를 수정하면 된다.  
> 최종적으로 수정한 데이터는 0110011 이다.

### 특징
- 해밍 코드 역시 짝수개의 데이터가 손실되면 검출할 수 없다.

[다양한 예시](https://velog.io/@octo__/%ED%95%B4%EB%B0%8D-%EC%BD%94%EB%93%9C-Hamming-Code)

---

## Reference 
📄 https://dos-soles.tistory.com/20  
📄 https://www.nise.go.kr/sedu/pt/page1_05.html
